//**************************************************************************************
//**************************************************************************************
//****										    ****
//****			Testprogramm fr Magnetmesssystem			    ****
//****										    ****
//****	auf Basis des AS5311 (Austriamicrosystems) V0.9	                            ****
//****	copyrigth (c) 2010 by Dipl. Ing. Steffen Taubmann                           ****
//****										    ****
//****	Kontakt: steffenta@gmx.de						    ****
//****										    ****
//**************************************************************************************
//****		 	  							    ****
//****	Fr private Anwender gilt:					            ****
//****		 								    ****
//****	 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen    ****
//****	 der GNU General Public License, wie von der Free Software Foundation       ****
//****	 verffentlicht, weitergeben und/oder modifizieren, entweder gem 	    ****
//****	 Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren Version.      ****
//****										    ****
//****	 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es      ****
//****	 Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne      ****
//****	 die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN    ****
//****	 BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.    ****
//****		 								    ****
//****	 Sie sollten ein Exemplar der GNU General Public License zusammen mit       ****
//****	 diesem Programm erhalten haben. 				            ****
//****	 Falls nicht, siehe <http://www.gnu.org/licenses/>.			    ****
//****										    ****
//****	 Die kommerzielle Verwendung des Quellcodes bedarf generell der Genehmigung ****
//****	 des Autors. Mit kommerzieller Verwendung ist der Verkauf von auf diesem    ****
//****	 Code basierenden Systemen zu verstehen. Der Einsatz des Systems in einem   ****
//****	 kommerziellen Umfeld ist davon nicht betroffen.			    ****
//****										    ****
//**************************************************************************************
//**************************************************************************************

unit main;

{$MODE Delphi}

interface

uses
  Windows, LCLIntf, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, Spin, LResources, inifiles;

type

  { TForm1 }

  TForm1 = class(TForm)
    Panel1: TPanel;
    LEmpfData: TLabel;
    LSendData: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Panel2: TPanel;
    Panel3: TPanel;
    BT_GetABSPos: TButton;
    BT_GetPos: TButton;
    BT_Reset: TButton;
    SE_ADR: TSpinEdit;
    Label3: TLabel;
    BT_Test: TButton;
    BT_GetMag: TButton;
    BT_SetAdr: TButton;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    P_ABSP: TPanel;
    P_Pos: TPanel;
    P_Mag: TPanel;
    Panel7: TPanel;
    CB_Auto: TCheckBox;
    Timer1: TTimer;
    CBA1: TCheckBox;
    CBA2: TCheckBox;
    CBA3: TCheckBox;
    CB_SDOK: TCheckBox;
    CB_COF: TCheckBox;
    CB_OCF: TCheckBox;
    CB_LIN: TCheckBox;
    CB_MagINC: TCheckBox;
    CB_MagDec: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BT_GetABSPosClick(Sender: TObject);
    procedure BT_GetPosClick(Sender: TObject);
    procedure BT_GetMagClick(Sender: TObject);
    procedure BT_TestClick(Sender: TObject);
    procedure BT_ResetClick(Sender: TObject);
    procedure CB_AutoClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BT_SetAdrClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Comm: THandle;
    buff: array[0..200]of char;
    PC_Comm: integer;
    Digits: integer;
 public
    { Public-Deklarationen }
    XPos,YPos: SmallInt;
    function PortInit(PCComm:Smallint):SmallInt;
    procedure sendData(SDaten: array of char; Anzahl: SmallInt);
    function GetData(Anzahl:SmallInt; Time :longint; var Daten: array of char):SmallInt;

    // Kommunikationsfunktionen
    function ResetSystem(Adr: Integer):Smallint;
    function GetABSPosition(Adr: Integer; var Pos,Flags: Integer):Smallint;
    function GetPosition(Adr: Integer; var Pos,Flags: Integer):Smallint;
    function GetMagnitude(Adr: Integer; var Mag,Flags: Integer):Smallint;
    function SetSysAdr(ADR: integer):Smallint;
    function SysTest(Adr: Integer):Smallint;
end;

var
  Form1: TForm1;

implementation

function dechex(zahl:byte):string;

 var high :byte;
     low  :byte;
     hstr :char;
     lstr :char;
  begin
   high:= zahl div 16;
   low := zahl mod 16;
   if high<=9 then hstr:=chr(high+48) else hstr:=chr(55+high);
   if low<=9 then lstr:=chr(low+48) else lstr:=chr(low+55);
   result:=hstr+lstr;

end;

    // Kommunikationsfunktionen
function TFORM1.ResetSystem(Adr: Integer):Smallint;
var data: array [0..100]of Char;
begin
 data[0]:=#3;
 data[1]:=chr(Adr);
 data[2]:='R';
 senddata(data,3);
 if getdata(4,200,data)=0 then result:=0 else result:=-1;
end;

function TFORM1.GetABSPosition(Adr: Integer; var Pos,Flags: Integer):Smallint;
var data: array [0..100]of Char;
    temp: integer;
begin
 data[0]:=#3;
 data[1]:=chr(Adr);
 data[2]:='P';
 senddata(data,3);
 if getdata(8,200,data)=0 then result:=0 else result:=-1;
 Temp:=ord(Data[2]); Temp:=Temp*$1000000; Pos:=Temp;
 Temp:=ord(Data[3]); Temp:=Temp*$10000; Pos:=Pos+Temp;
 Temp:=ord(Data[4]); Temp:=Temp*$100; Pos:=Pos+Temp;
 Temp:=ord(Data[5]); Pos:=Pos+Temp;
 Flags:=ord(Data[6]);
end;

function TFORM1.GetPosition(Adr: Integer; var Pos,Flags: Integer):Smallint;
var data: array [0..100]of Char;
    temp: integer;
begin
 data[0]:=#3;
 data[1]:=chr(Adr);
 data[2]:='p';
 senddata(data,3);
 if getdata(6,200,data)=0 then result:=0 else result:=-1;
 Temp:=ord(Data[2]); Temp:=Temp*$100; Pos:=Temp;
 Temp:=ord(Data[3]); Pos:=Pos+Temp;
 Flags:=ord(Data[4]);
end;

function TFORM1.GetMagnitude(Adr: Integer; var Mag,Flags: Integer):Smallint;
var data: array [0..100]of Char;
    temp: integer;
begin
 data[0]:=#3;
 data[1]:=chr(Adr);
 data[2]:='m';
 senddata(data,3);
 if getdata(6,200,data)=0 then result:=0 else result:=-1;
 Temp:=ord(Data[2]); Temp:=Temp*$100; Mag:=Temp;
 Temp:=ord(Data[3]); Mag:=Mag+Temp;
 Flags:=ord(Data[4]);
end;

function TFORM1.SetSysAdr(ADR: integer):Smallint;
var data: array [0..100]of Char;
begin
 data[0]:=#6;
 data[1]:=#$FF;
 data[2]:='A';
 data[3]:=chr(adr);
 data[4]:='A';
 data[5]:=chr(adr);
 senddata(data,6);
 if getdata(4,200,data)=0 then result:=0 else result:=-1;
end;
function TFORM1.SysTest(Adr: Integer):Smallint;
var data: array [0..100]of Char;
begin
 data[0]:=#3;
 data[1]:=chr(Adr);
 data[2]:=#$F0;
 senddata(data,3);
 if getdata(4,200,data)=0 then result:=0 else result:=-1;
end;

function TFORM1.PortInit(PCComm:Smallint):SmallInt;
 var
  cid       : THandle;
  m2        : THandle;
  prog,port : PChar;
  merker1   : longbool;
  comst     : tdcb;
  CommTimeouts: TCommTimeouts;

 begin
  cid:=Comm; {letzte genutzte Schnittstelle}
  port:=strnew('com1');
  prog:=strnew('38400,e,8,1');

   if cid<>0 then closeHandle(cid);
   case PCComm of
    1: begin
        port:=strnew('com1');
        prog:=strnew('38400,e,8,1');
       end;
    2: begin
        port:=strnew('COM2');
        prog:=strnew('38400,e,8,1');
       end;
    3: begin
        port:=strnew('com3');
        prog:=strnew('38400,e,8,1');
       end;
    4: begin
        port:=strnew('com4');
        prog:=strnew('38400,e,8,1');
       end;
    end;

    comst.flags:=$3 {or $3000};
    comst.xonlim:=0;
    comst.xofflim:=0;
    comst.Baudrate:=38400;
    comst.parity:=EVENPARITY;
    comst.Bytesize:=8;
    comst.stopbits:=0;
    comst.DCBlength:=SizeOf(comst);
    m2:=CreateFile(port ,GENERIC_READ or GENERIC_WRITE , 0, nil, OPEN_EXISTING, FILE_FLAG_WRITE_THROUGH, 0);

    if (m2>0)and(SetupComm(m2,200,200)) then
     begin
      comm:=m2;
      CommTimeouts.ReadIntervalTimeout:=4;
      CommTimeouts.ReadTotalTimeoutMultiplier:=1;
      CommTimeouts.ReadTotalTimeoutConstant:=10;
      CommTimeouts.WriteTotalTimeoutMultiplier:=10;
      CommTimeouts.WriteTotalTimeoutconstant:=100;
      SetCommTimeouts(m2,CommTimeouts);
      merker1:=setcommstate(m2,comst);
      SetCommMask(m2,EV_TXEMPTY); {alle Zeichen gesendet oder bertragungsfehler}
      escapecommfunction(m2,clrdtr);
      result:=0;
     end
    else
     begin
      result:=-1;
      Comm:=0;
     end; 
  strdispose(port);
  strdispose(prog);
 end;

procedure TForm1.sendData(SDaten: array of char; Anzahl: SmallInt);

var      len: DWord;
         x: SmallInt;
         bcc : byte;
         s_Stat: DWord;
//         c,t1,t2,t3: TLargeInteger;
         test: longbool;
         str:string;
begin
     SDaten[Anzahl]:=#0;
     bcc:=ord(SDaten[0]);
     for x:=1 to (anzahl-1) do bcc:=bcc xor ord(SDAten[x]);
     SDaten[anzahl]:=chr(bcc);
     for x:=0 to anzahl+1 do buff[x]:=sDaten[x];

     str:=IntToStr(anzahl+1)+' Byte: ';
     for x:=0 to anzahl do
      str:=str+DecHex(ord(buff[x]))+' ';
     LSendData.Caption:=str;
     LEmpfData.Caption:='Warte auf Antwort';
     escapecommfunction(comm,setrts);
     PurgeComm(comm,PURGE_TXCLEAR or PURGE_TXABORT);
     PurgeComm(Comm,PURGE_RXCLEAR or PURGE_RXABORT);
     test:=WriteFile(Comm,buff,Anzahl+1,len,nil);
     s_Stat:=0;
     WaitCommEvent(Comm,s_stat,nil);         {warten, bis alle Bytes geschrieben}
//     QueryPerformanceFrequency(c);             {Frequenz des Timers}
//     QueryPerformanceCounter(t1);              {Startzeit}
//     t2:=t1;
     // Umschaltung auf Empfang, wenn alle Bytes gesendet
     // wird bei Nutzung des FT232R basierenden RS485 Sticks nicht bentigt
     // Werte sind fr 9600 Baud
//     while (t2-t1)<((c*(Anzahl+2))/873) do  QueryPerformanceCounter(t2); {1,1458 ms*Anzahl Bytes}
//     escapecommfunction(Comm,clrrts);
end;

function TForm1.GetData(Anzahl:SmallInt; Time :longint; var Daten: array of char):SmallInt;

var       x: longint;
          y: SmallInt;
          anz: DWord;
          Timeout: longint;
          bcc: byte;
          dl: integer;
          test: String;

begin
     dl:=Anzahl;
     Daten[0]:=#0;
     Daten[1]:=#0;
     x:=0;
     anz:=0;
     timeout:=gettickcount;
     while (gettickcount-timeout<time) and (x<dl) do
      begin
       application.processmessages;
       ReadFile(Comm,buff,200,anz,nil);
       if anz>200 then anz:=200;
       buff[anz]:=#0;
       if anz>0 then for y:=1 to anz do daten[x+y-1]:=buff[y-1];
       x:=x+anz;

       if (x>0)and(x=ord(Daten[0])+1) then
        begin
         if x<>dl then
          begin
//           result:=x;
           break;
          end;
        end;
//       result:=0;
      end;

     result:=0;
     bcc:=0;

     Test:=IntToStr(x)+' Byte: ';
     for y:=0 to x-1 do
      test:=test+DecHex(ord(daten[y]))+' ';
     LEmpfData.Caption:=test;

     if x>200 then x:=200;
     if x<0 then x:=0;
     for y:=0 to x-2 do bcc:=bcc xor ord(daten[y]);
     result:=ord(Daten[1]);
     if x=0 then result:=-10;

     if (bcc<>ord(daten[x-1]))and(x>0)then result:=-30;
end;


procedure TForm1.FormShow(Sender: TObject);
begin
 Form1.Caption:='Testprog MMS COM'+inttostr(PC_Comm);
 Portinit(PC_Comm)
end;

procedure TForm1.FormCreate(Sender: TObject);
var aktpfad: String;
    ini: TInifile;
begin
Getdir(0,aktpfad);
ini:=TInifile.create(aktpfad+'\MMS.ini');
PC_Comm:=ini.readinteger('Value','Port',1);
Digits:=ini.readinteger('Value','Digits',2);
ini.free;
end;

procedure TForm1.BT_GetABSPosClick(Sender: TObject);
var Value, Flags: Integer;
    V2: real;
begin
 GetAbsPosition(SE_Adr.Value,Value,Flags);
 V2:=Value; V2:=V2/2048;
 P_AbsP.Caption:=FloatToStrF(V2, ffFixed, 12, digits)+'mm';
 CB_LIN.Font.Color:=clBlack;
 CB_MagInc.Font.Color:=clBlack;
 CB_MagDec.Font.Color:=clBlack;
 if (Flags and 1)=1 then CB_MagDec.checked:=true else CB_MagDec.checked:=false;
 if (Flags and 2)=2 then CB_MagInc.checked:=true else CB_MagInc.checked:=false;
 if (Flags and 4)=4 then CB_LIN.checked:=true else CB_Lin.checked:=false;
 if (Flags and 8)=8 then CB_COF.checked:=true else CB_COF.checked:=false;
 if (Flags and 16)=16 then CB_OCF.checked:=true else CB_OCF.checked:=false;
 if (Flags and 32)=32 then CB_SDOK.checked:=true else CB_SDOK.checked:=false;
end;

procedure TForm1.BT_GetPosClick(Sender: TObject);
var Value, Flags: Integer;
begin
 GetPosition(SE_Adr.Value,Value,Flags);
 P_Pos.Caption:=inttostr(Value);
 CB_LIN.Font.Color:=clBlack;
 CB_MagInc.Font.Color:=clBlack;
 CB_MagDec.Font.Color:=clBlack;
 if (Flags and 1)=1 then CB_MagDec.checked:=true else CB_MagDec.checked:=false;
 if (Flags and 2)=2 then CB_MagInc.checked:=true else CB_MagInc.checked:=false;
 if (Flags and 4)=4 then CB_LIN.checked:=true else CB_Lin.checked:=false;
 if (Flags and 8)=8 then CB_COF.checked:=true else CB_COF.checked:=false;
 if (Flags and 16)=16 then CB_OCF.checked:=true else CB_OCF.checked:=false;
 if (Flags and 32)=32 then CB_SDOK.checked:=true else CB_SDOK.checked:=false;
end;

procedure TForm1.BT_GetMagClick(Sender: TObject);
var Value, Flags: Integer;
begin
 GetMagnitude(SE_Adr.Value,Value,Flags);
 P_Mag.Caption:='0x'+DecHex(Value);
 if (Flags and 1)=1 then CB_MagDec.checked:=true else CB_MagDec.checked:=false;
 if (Flags and 2)=2 then CB_MagInc.checked:=true else CB_MagInc.checked:=false;
 if (Flags and 4)=4 then CB_LIN.checked:=true else CB_Lin.checked:=false;
 if (Flags and 8)=8 then CB_COF.checked:=true else CB_COF.checked:=false;
 if (Flags and 16)=16 then CB_OCF.checked:=true else CB_OCF.checked:=false;
 if (Flags and 32)=32 then CB_SDOK.checked:=true else CB_SDOK.checked:=false;

 if Value=$3F then
  begin
    CB_LIN.Font.Color:=clgreen;
    CB_MagInc.Font.Color:=clgreen;
    CB_MagDec.Font.Color:=clgreen;
  end
 else
   if (Value>$20) And (Value<$5F) And Not CB_LIN.Checked then
    begin
      CB_LIN.Font.Color:=clyellow;
      CB_MagInc.Font.Color:=clyellow;
      CB_MagDec.Font.Color:=clyellow;
    end
   else
    begin
      CB_LIN.Font.Color:=clred;
      CB_MagInc.Font.Color:=clred;
      CB_MagDec.Font.Color:=clred;
    end;
end;

procedure TForm1.BT_TestClick(Sender: TObject);
begin
 SysTest(SE_Adr.Value);
end;

procedure TForm1.BT_ResetClick(Sender: TObject);
begin
 ResetSystem(SE_Adr.Value);
end;

procedure TForm1.CB_AutoClick(Sender: TObject);
begin
 if (CB_Auto.Checked) then Timer1.enabled:=true else Timer1.enabled:=false;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
 timer1.enabled:=false;
 if CBA1.Checked then BT_GetABSPosClick(nil);
 if CBA2.Checked then BT_GetPosClick(nil);
 if CBA3.Checked then BT_GetMagClick(nil);
 if (CB_Auto.Checked) then Timer1.enabled:=true;
end;

procedure TForm1.BT_SetAdrClick(Sender: TObject);
begin
 SetSysAdr(SE_ADR.value);
end;

initialization
  {$i main.lrs}
  {$i main.lrs}

end.
